/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.guns.util;

import dev.toma.gunsrpg.common.item.guns.util.IAdditionalShootData;
import dev.toma.gunsrpg.util.properties.IPropertySerializer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public interface IEntityTrackingGun
extends IAdditionalShootData {
    public boolean canBeGuided(PlayerEntity var1);

    public int getMaxRange();

    public int getLockTime();

    public static class GuidenanceProperties {
        public static final GuidenanceProperties PLAYER = new GuidenanceProperties(7.0f, 7.0f, 4.0f, 75.0f);
        public static final GuidenanceProperties GUNNER_AIR = new GuidenanceProperties(6.0f, 6.0f, 8.0f, 90.0f);
        public static final GuidenanceProperties GUNNER_GROUND = new GuidenanceProperties(0.5f, 1.3f, 0.0f, 90.0f);
        public static final GuidenanceProperties TURRET = new GuidenanceProperties(8.5f, 8.5f, 16.0f, 90.0f);
        public static final IPropertySerializer<GuidenanceProperties> SERIALIZER = new Serializer();
        private final float maxPitch;
        private final float maxYaw;
        private final float maxProximityDistanceSqr;
        private final float maxGuidenanceAngle;

        public GuidenanceProperties(float maxPitch, float maxYaw, float maxProximityDistanceSqr, float maxGuidenanceAngle) {
            this.maxPitch = maxPitch;
            this.maxYaw = maxYaw;
            this.maxProximityDistanceSqr = maxProximityDistanceSqr;
            this.maxGuidenanceAngle = maxGuidenanceAngle;
        }

        public float getMaxPitch() {
            return this.maxPitch;
        }

        public float getMaxYaw() {
            return this.maxYaw;
        }

        public float getMaxProximityDistanceSqr() {
            return this.maxProximityDistanceSqr;
        }

        public float getMaxGuidenanceAngle() {
            return this.maxGuidenanceAngle;
        }

        private static final class Serializer
        implements IPropertySerializer<GuidenanceProperties> {
            private Serializer() {
            }

            @Override
            public void encode(PacketBuffer buffer, GuidenanceProperties value) {
                buffer.writeFloat(value.maxPitch);
                buffer.writeFloat(value.maxYaw);
                buffer.writeFloat(value.maxProximityDistanceSqr);
                buffer.writeFloat(value.maxGuidenanceAngle);
            }

            @Override
            public GuidenanceProperties decode(PacketBuffer buffer) {
                return new GuidenanceProperties(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        }
    }
}

